<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLTranslation\Administrator\View\Dashboard;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\JLTranslation\Helper\TranslationHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;
use Joomla\Plugin\System\Joomlab\Helper\PluginHelper;

class HtmlView extends BaseHtmlView
{
    protected array $cards = [];

    public function display($tpl = null)
    {
        PluginHelper::checkUpdate('jltranslation', 'pro', 'https://joomlab.net/joomlab-translation');
        $this->cards = TranslationHelper::getDashboardCardData();

        parent::display($tpl);
        $this->addToolbar();
    }

    protected function addToolbar()
    {
        $toolbar  = BackwardCompatibilityHelper::getToolbar();
        $user     = $this->getCurrentUser();
        $option   = 'com_jltranslation';
        ToolbarHelper::title(Text::_('COM_JLTRANSLATION_PAGE_DASHBOARD'));

        if ($user->authorise('core.admin', $option) || $user->authorise('core.options', $option)) {
            $toolbar->preferences($option);
        }
    }
}
