<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLTranslation\Administrator\View\Translation;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;
use Joomla\Plugin\System\Joomlab\MVC\View\ItemView;

class HtmlView extends ItemView
{
    protected TranslationExtensionAbstract $extensionClass;
    protected Form $originalForm;

    protected Form $translatedForm;

    protected string $pageTitle = '';

    public function display($tpl = null)
    {
        $this->extensionClass = $this->get('ExtensionClass');
        [$this->originalForm, $this->translatedForm] = $this->get('Forms');

        parent::display($tpl);
    }

    protected function addToolbar()
    {
        Factory::getApplication()->input->set('hidemainmenu', true);
        $language        = $this->state->get('filter.language');
        $defaultSiteLang = ComponentHelper::getParams('com_languages')->get('site', 'en-GB');
        $fromLanguage    = LanguageHelper::langCodeToFlag($defaultSiteLang) . ' ' . $defaultSiteLang;
        $toLanguage      = LanguageHelper::langCodeToFlag($language) . ' ' . $language;
        $title           = trim($this->item->{$this->extensionClass->getTitleField()});
        $this->pageTitle = Text::sprintf(
            'COM_JLTRANSLATION_TRANSLATION_FROM_TO_LANGUAGE_PAGE_TITLE',
            $this->extensionClass->getTitle(),
            substr($title, 0, 20) . (strlen($title) > 20 ? '...' : ''),
            $fromLanguage,
            $toLanguage
        );

        ToolbarHelper::title($this->pageTitle);

        $toolbar = BackwardCompatibilityHelper::getToolbar();
        $toolbar->apply('translation.apply');
        $toolbar->save('translation.save');
        $toolbar->cancel('translation.cancel');
        $toolbar->inlinehelp();
    }
}
