<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\JLTranslation\Administrator\Extension\JLTranslationComponent;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;

HTMLHelper::_('joomlab.framework');
$language   = Factory::getApplication()->getLanguage();
$components = array_values(
    array_unique(
        array_map(function ($card) use ($language) {
            $component = $card['component'];
            $language->load($component . '.sys', JPATH_ADMINISTRATOR . '/components/' . $component)
            || $language->load($component . '.sys', JPATH_ADMINISTRATOR);

            return $component;
        }, $this->cards)
    )
);

$this->getDocument()->getWebAssetManager()->addInlineScript(<<<JAVASCRIPT
document.addEventListener('DOMContentLoaded', function() {
    const dashboard = document.getElementById('jl-translation-dashboard');
    const filterData = new Proxy({ title: '', component: '' }, {
        set(target, property, value) {
            target[property] = value;
            dashboard.querySelectorAll('.jl-translation-dashboard__card').forEach(card => {
                const { filterTitle, filterComponent } = card.dataset;
                card.hidden = (filterTitle && !filterTitle.toLowerCase().includes(target.title.toLowerCase())) || (target.component && filterComponent !== target.component);
            });
            
            localStorage.setItem('com_jltranslation.dashboardFilter', JSON.stringify(target));
           
            return true;
        }
    });
    
    // Handle search
    const searchInput = document.getElementById('jl-dashboard-search');
    searchInput.addEventListener('input', () => filterData.title = searchInput.value?.trim() || '');
    
    // Handle filter
    dashboard.querySelectorAll('[data-control-component]').forEach(ctrl => {
        ctrl.querySelector('a').addEventListener('click', e => {
            e.preventDefault();
            e.stopPropagation();
            dashboard.querySelector('[data-control-component].uk-active')?.classList.remove('uk-active');
            dashboard.querySelector('.jl-translation-dashboard__more-nav.uk-active')?.classList.remove('uk-active');
            ctrl.classList.add('uk-active');
            const dropNav = ctrl.closest('.jl-translation-dashboard__more-nav');
            
            if (dropNav) {
                dropNav.classList.add('uk-active');
            }
            
            filterData.component = ctrl.dataset.controlComponent;
        });
    });
    
    // Init page
    try {
        const stateData = localStorage.getItem('com_jltranslation.dashboardFilter');
        
        if (stateData) {
            const jsonData = JSON.parse(stateData);
            
            if (jsonData.title) {
                searchInput.value = jsonData.title;
                searchInput.dispatchEvent(new InputEvent('input'));
            }
            
            if (jsonData.component) {
                dashboard.querySelector('[data-control-component="' + jsonData.component + '"] > a')?.click();
            }
        }
    } catch {}
});
JAVASCRIPT
);

$i = 0;
?>

<div class="jl-scope" id="jl-translation-dashboard">
    <div class="uk-background-default uk-box-shadow-small uk-margin">
        <div class="uk-container">
            <nav class="uk-navbar-container uk-navbar-transparent uk-margin">
                <div uk-navbar="mode: click" class="uk-grid-small uk-flex-middle" uk-grid>
                    <div class="uk-width-expand@m uk-width-1-1">
                        <ul class="uk-navbar-nav uk-overflow-auto">
                            <li class="uk-active" data-control-component="">
                                <a href="#"><?php echo Text::_('JALL'); ?></a>
                            </li>
                            <?php foreach ($components as $component):

                                if ($i++ === 5) {
                                    break;
                                }

                                ?>
                                <li data-control-component="<?php echo $component; ?>">
                                    <a href="#"><?php echo Text::_(strtoupper($component)); ?></a>
                                </li>

                            <?php endforeach; ?>
                            <?php if (isset($components[$i])): ?>
                                <li class="jl-translation-dashboard__more-nav">
                                    <a href="#">
                                        <span uk-icon="menu"></span>
                                        <?php echo Text::_('COM_JLTRANSLATION_MORE'); ?>
                                    </a>
                                    <div class="uk-navbar-dropdown">
                                        <ul class="uk-nav uk-navbar-dropdown-nav">
                                            <?php while ($component = ($components[$i++] ?? null)): ?>
                                                <li data-control-component="<?php echo $component; ?>">
                                                    <a href="#"><?php echo Text::_(strtoupper($component)); ?></a>
                                                </li>
                                            <?php endwhile; ?>
                                        </ul>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="uk-width-small@m">
                        <div class="uk-search uk-search-navbar uk-width-1-1">
                            <input class="uk-search-input" type="search" placeholder="<?php echo Text::_('JSEARCH_FILTER', true); ?>" id="jl-dashboard-search" autofocus>
                        </div>
                        <div class="uk-margin-bottom uk-hidden@m"></div>
                    </div>
                </div>
            </nav>
        </div>
    </div>
    <div class="uk-grid-small uk-child-width-1-2 uk-child-width-1-6@l uk-child-width-1-4@m" uk-grid="masonry: pack">
        <?php foreach ($this->cards as $card): ?>
            <div class="jl-translation-dashboard__card" data-filter-title="<?php echo htmlspecialchars($card['title']); ?>" data-filter-component="<?php echo htmlspecialchars($card['component']); ?>">
                <div class="uk-card uk-card-default uk-card-small uk-card-body">
                    <h5 class="uk-margin-remove">
                        <a class="uk-link-text" href="<?php echo Route::_('index.php?option=com_jltranslation&view=translations&filter[table]=' . $card['table'], false); ?>">
                            <?php echo $card['title']; ?>
                        </a><br>
                        <small class="uk-text-small"><?php echo Text::plural('COM_JLTRANSLATION_TOTAL_ITEMS', $card['total'], $card['total']); ?></small>
                    </h5>
                    <dl class="uk-description-list uk-margin-remove">
                        <?php foreach ($card['count'] as $language => $count): ?>
                            <dt><?php echo LanguageHelper::langCodeToFlag($language) . ' ' . $language; ?></dt>
                            <dd class="uk-text-small">
                                <?php echo $count['enabled'] . ' <i class="fa fa-check-circle text-primary"></i>' ?>
                                <?php echo $count['disabled'] . ' <i class="fa fa-times-circle text-danger"></i>'; ?>
                            </dd>
                        <?php endforeach; ?>
                    </dl>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    <?php echo JLTranslationComponent::renderBottomLink(); ?>
</div>