document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.js-form__field-translation-container').forEach(container => {
        container.querySelectorAll('li > a[data-translation-field-index]').forEach(field => {
            const index = parseInt(field.dataset.translationFieldIndex);
            if (!isNaN(index) && index >= 1) {
                field.classList.add('disabled');
                field.dataset.bsToggle = 'popover';
                field.dataset.bsTitle = 'Enable Joomlab translation PRO tier to unlock all features.';
                if (bootstrap?.Popover) {
                    new bootstrap.Popover(field, {trigger: 'hover'});
                }
            }
        });
    });

    const btnLanguages = document.querySelectorAll('joomla-toolbar-button[id^="translation-group-children-jl-translation-language-"] > button');
    btnLanguages.forEach(btn => {
        btn.addEventListener('click', e => {
            e.preventDefault();
            e.stopPropagation();
            let modal = document.getElementById('jl-translation-modal');

            if (!modal) {
                modal = document.createElement('div');
                modal.style.zIndex = '9999';
                modal.innerHTML = '<div class="uk-modal-dialog uk-modal-body"><button class="uk-modal-close-default" type="button" uk-close></button><p>Enable <strong>Joomlab translation PRO</strong> tier to unlock all features.</p><p><a href="https://joomlab.net/joomlab-extension-subscription?JLForm[extension]=Joomlab%20Translation%20Pro" target="_blank">Get PRO version</a></p></div>';
                document.body.appendChild(modal);
            }

            UIkit.modal(modal).show();
        });
    });
});