<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Module\JLTranslationLanguages\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;
use Joomla\Registry\Registry;

class JLTranslationLanguagesHelper
{
    public static function getAjax()
    {
        $app           = Factory::getApplication();
        $vars          = json_decode(base64_decode($app->getInput()->getBase64('vars', '')), true) ?: [];
        $requestedWith = $app->getInput()->server->getString('HTTP_X_REQUESTED_WITH');
        $languageTag   = $app->getLanguage()->getTag();
        $url           = new Uri(Route::_('index.php?' . http_build_query($vars), false));

        if ($languageTag === LanguageHelper::getDefaultLang()
            && $app->get('sef')
            && ($languageFilter = PluginHelper::getPlugin('system', 'languagefilter'))
            && (new Registry($languageFilter->params))->get('remove_default_prefix')
        ) {
            foreach (LanguageHelper::getLanguages() as $language) {
                if ($languageTag === $language->lang_code) {
                    $path = $url->getPath();
                    $root = Uri::root(true) . '/';

                    if (str_contains($path, 'index.php') && !str_contains($path, 'index.php/' . $language->sef)) {
                        $url->setPath(str_replace('index.php', 'index.php/' . $language->sef, $path));
                    } elseif (!str_ends_with($root, $language->sef)) {
                       $url->setPath(preg_replace('#^' . preg_quote($root, '#') . '#', $root . $language->sef . '/', $path, 1));
                    }

                    break;
                }
            }
        }


        if (0 !== strcasecmp($requestedWith, 'XMLHttpRequest') && 0 !== strcasecmp($requestedWith, 'Fetch')) {
            $app->redirect($url->toString());
        }

        ob_clean();
        echo $url->toString();

        $app->close();
    }
}
