<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop;

defined('_JEXEC') or die;

class Category extends TranslationExtensionBase
{
    public function registerTranslationFields(): array
    {
        return [
            'category_name',
            'category_description',
            'category_meta_description',
            'category_keywords',
            'product_url',
            'category_page_title',
            'category_alias',
            'category_canonical',
        ];
    }

    public function getTitleField(): string
    {
        return 'category_name';
    }

    public function getReferenceTable(): string
    {
        return 'hikashop_category';
    }

    public function getKey(): string
    {
        return 'category_id';
    }
}