<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop;

use Joomla\Database\QueryInterface;
use Joomla\Utilities\ArrayHelper;

defined('_JEXEC') or die;

class Product extends TranslationExtensionBase
{
    public function registerTranslationFields(): array
    {
        return [
            'product_name',
            'product_page_title',
            'product_url',
            'product_alias',
            'product_canonical',
            'product_meta_description',
            'product_description',
        ];
    }

    public function getTitleField(): string
    {
        return 'product_name';
    }

    public function getReferenceTable(): string
    {
        return 'hikashop_product';
    }

    public function getKey(): string
    {
        return 'product_id';
    }

    public function prepareListQuery(QueryInterface $query): void
    {
        if ($categoryId = $this->translationsModel->getState('filter.category_id', [])) {
            if (!is_array($categoryId)) {
                $categoryId = [$categoryId];
            }

            $categoryId = ArrayHelper::toInteger($categoryId);
            $db         = $this->getDatabase();
            $query->join('INNER', $db->quoteName('#__hikashop_product_category', 'c'), 'a.product_id = c.product_id')
                ->where('c.category_id IN (' . implode(',', $categoryId) . ')');
        }
    }

}