<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\JLTranslation\Solidres\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\User\UserFactoryAwareInterface;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Country;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Coupon;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Currency;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Expcategory;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Experience;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Extra;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Facility;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Reservationasset;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Roomtype;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Status;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Subscriptionlevel;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Theme;
use Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres\Transportation;
use Joomla\Plugin\System\JLTranslation\Event\ExtensionEvent;
use Joomla\Plugin\System\JLTranslation\Event\RegisterEvent;

final class Solidres extends CMSPlugin implements DatabaseAwareInterface, UserFactoryAwareInterface, SubscriberInterface
{
    use DatabaseAwareTrait;
    use UserFactoryAwareTrait;

    protected $autoloadLanguage = true;


    public static function getSubscribedEvents(): array
    {
        return ComponentHelper::isEnabled('com_solidres') ? [
            'onJLTranslationBootExtensions' => 'bootExtensions',
            'onJLTranslationRegister'       => 'registerEvent',
        ] : [];
    }

    public function bootExtensions(ExtensionEvent $event): void
    {
        $subject       = $event->getArgument('subject');
        $subject->data = array_merge(
            $subject->data,
            [
                Country::class,
                Coupon::class,
                Currency::class,
                Expcategory::class,
                Experience::class,
                Extra::class,
                Facility::class,
                Reservationasset::class,
                Roomtype::class,
                Status::class,
                Subscriptionlevel::class,
                Theme::class,
                Transportation::class,
            ]
        );
    }

    public function registerEvent(RegisterEvent $event): void
    {
        $data = $event->getEventData();

        // Property
        $data->prepareForm[] = 'onReservationAssetPrepareForm';
        $data->prepareData[] = 'onReservationAssetPrepareData';

        // Room type
        $data->prepareForm[] = 'onRoomTypePrepareForm';
        $data->prepareData[] = 'onRoomTypePrepareData';

        // For none standard J! core (Those don't have the prepare data event)
        $data->prepareForm[] = ['onContentPrepareForm', [$this, 'parseFormData']];
    }

    public function parseFormData(Event $event): void
    {
        $form     = $event->getArgument('subject');
        $data     = $event->getArgument('data');
        $contexts = [
            'com_solidres.coupon',
            'com_solidres.country',
            'com_solidres.currency',
            'com_solidres.extra',
            'com_solidres.status',
        ];

        if (!$form instanceof Form || !in_array($form->getName(), $contexts)) {
            return;
        }

        RegisterEvent::getInstance()
            ->prepareData(new Event('onContentPrepareForm', ['context' => $form->getName(), 'data' => $data]));
    }
}