<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\JLTranslation\Solidres\Extension\Solidres;

defined('_JEXEC') or die;

use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;

class Experience extends TranslationExtensionAbstract
{
    public function registerTranslationFields(): array
    {
        return [
            'name',
            'alias',
            'base_location',
            'end_location',
            'price_includes',
            'price_excludes',
            'cancellation_policy',
            'languages',
            'description_short',
            'description_long',
            'meta_title',
            'meta_key',
            'meta_desc',
            'tab_content',
        ];
    }

    public function getTitleField(): ?string
    {
        return 'name';
    }

    public function getReferenceTable(): string
    {
        return 'sr_experiences';
    }
}