<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Extension\Categories;

defined('_JEXEC') or die;

use Joomla\Database\ParameterType;
use Joomla\Database\QueryInterface;
use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionNested;

class Category extends TranslationExtensionNested
{
    public function registerTranslationFields(): array
    {
        return [
            'title',
            'alias',
            'description',
            'metadesc',
            'metakey',
            'params.image',
            'params.image_alt',
        ];
    }

    public function getTitleField(): ?string
    {
        return 'title';
    }

    public function getReferenceTable(): string
    {
        return 'categories';
    }

    public function prepareListQuery(QueryInterface $query): void
    {
        $query->clear('select')
            ->select('a.id, CONCAT(a.title, \' (\', a.extension, \')\') AS title')
            ->where('a.title <> \'ROOT\'');

        if ($extension = $this->translationsModel->getState('filter.extension', [])) {
            $query->where('a.extension IN (' . implode(',', $query->bindArray($extension, ParameterType::STRING)) . ')');
        }
    }
}