<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Extension\Contact;

defined('_JEXEC') or die;

use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;

class Contact extends TranslationExtensionAbstract
{
    public function registerTranslationFields(): array
    {
        return [
            'name',
            'alias',
            'image',
            'con_position',
            'email_to',
            'address',
            'suburb',
            'state',
            'postcode',
            'country',
            'telephone',
            'mobile',
            'fax',
            'webpage',
            'misc',
            'metadesc',
            'metakey',
            'params.linka_name',
            'params.linka',
            'params.linkb_name',
            'params.linkb',
            'params.linkc_name',
            'params.linkc',
            'params.linkd_name',
            'params.linkd',
            'params.linke_name',
            'params.linke',
            'params.redirect',
        ];
    }

    public function getTitleField(): ?string
    {
        return 'name';
    }

    public function getReferenceTable(): string
    {
        return 'contact_details';
    }
}