<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Extension\Modules;

defined('_JEXEC') or die;

use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;

class Module extends TranslationExtensionAbstract
{
    public function registerTranslationFields(): array
    {
        $fields = ['title', 'content'];

        if ($this->form) {
            foreach ($this->form->getGroup('params') as $formField) {
                $type        = strtolower($formField->__get('type'));
                $name        = $formField->__get('fieldname');
                $allowTypes  = ['text', 'textarea', 'editor', 'media'];
                $ignoreNames = ['moduleclass_sfx', 'header_class'];

                if (in_array($type, $allowTypes) && !in_array($name, $ignoreNames)) {
                    $fields[] = 'params.' . $formField->__get('fieldname');
                }
            }
        } else {
            $fields[] = 'params';
        }

        return $fields;
    }

    public function getTitleField(): ?string
    {
        return 'title';
    }

    public function getReferenceTable(): string
    {
        return 'modules';
    }
}