<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Extension\Tags;

defined('_JEXEC') or die;

use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionNested;
use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionPrepareStatementInterface;
use Joomla\Plugin\System\JLTranslation\Helper\TranslationHelper;
use stdClass;

class Tag extends TranslationExtensionNested implements TranslationExtensionPrepareStatementInterface
{
    public function registerTranslationFields(): array
    {
        return [
            'title',
            'alias',
            'description',
            'metadesc',
            'metakey',
            'images.image_intro',
            'images.image_intro_alt',
            'images.image_intro_caption',
            'images.image_fulltext',
            'images.image_fulltext_alt',
            'images.image_fulltext_caption',
        ];
    }

    public function prepareStatementFetchResult(object|array &$result): void
    {
        // Check to manual handle for tag module
        if (is_object($result) && !empty($result->tag_id)) {
            $item     = new stdClass();
            $item->id = $result->tag_id;
            $fields   = ['path', 'title', 'alias', 'images'];

            foreach ($fields as $field) {
                if (isset($result->{$field})) {
                    $item->{$field} = $result->{$field};
                }
            }

            TranslationHelper::translate('tags', $item);

            foreach ($fields as $field) {
                if (isset($result->{$field})) {
                    $result->{$field} = $item->{$field};
                }
            }
        }
    }

    public function getTitleField(): ?string
    {
        return 'title';
    }

    public function getReferenceTable(): string
    {
        return 'tags';
    }
}