<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\WebAsset\WebAssetManager;

class AssetHelper
{
    public static function getWebAssetManager(): WebAssetManager
    {
        $app = Factory::getApplication();
        $doc = $app->getDocument();

        if (!$doc) {
            $app->loadDocument();
            $doc = $app->getDocument();
        }

        return $doc->getWebAssetManager();
    }
}