<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Http\Http;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper as CMSPluginHelper;
use Joomla\Database\DatabaseInterface;
use Throwable;

defined('_JEXEC') or die;

class PluginHelper
{
    public static function checkUpdate(string $type, string $plugin, string $infoUrl): void
    {
        if (!CMSPluginHelper::isEnabled($type, $plugin)) {
            return;
        }

        $app          = Factory::getApplication();
        $package      = 'plg_' . $type . '_' . $plugin;
        $checkKey     = $package . '.checkUpdateVersion';
        $checkVersion = $app->getUserState($checkKey);
        $upVersion    = null;

        if (!is_array($checkVersion) || $checkVersion['time'] < time()) {
            $checkValue       = ['time' => time() + 300];
            $advanceUpdateUrl = 'https://joomlab.net/joomlab-extensions/update/' . $package . '.xml';

            try {
                $response = (new Http())->get($advanceUpdateUrl, [], 30);

                if ($response->getStatusCode() === 200
                    && ($xml = simplexml_load_string($response->body))
                    && ($version = $xml->update->version ?? null)
                ) {
                    $version = (string)$version;
                    $db      = Factory::getContainer()->get(DatabaseInterface::class);
                    $query   = $db->getQuery(true)
                        ->select($db->quoteName('manifest_cache'))
                        ->from($db->quoteName('#__extensions'))
                        ->where(
                            [
                                $db->quoteName('folder') . ' = ' . $db->quote($type),
                                $db->quoteName('element') . ' = ' . $db->quote($plugin),
                                $db->quoteName('type') . ' = ' . $db->quote('plugin'),
                            ]
                        );


                    $manifest = json_decode($db->setQuery($query)->loadResult() ?: '{}', true);

                    if (isset($manifest['version']) && version_compare($manifest['version'], $version, 'lt')) {
                        $upVersion             = $version;
                        $checkValue['version'] = $version;
                    }
                }
            } catch (Throwable $e) {
            }

            $app->setUserState($checkKey, $checkValue);
        } else {
            $upVersion = $checkVersion['version'] ?? null;
        }

        if ($upVersion) {
            $app->enqueueMessage(Text::sprintf('PLG_SYSTEM_JOOMLAB_PRO_VERSION_AVAILABLE_MSG', $upVersion, $infoUrl), 'info');
        }
    }
}