<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;

defined('_JEXEC') or die;

/**
 * @var array $fields
 */

extract($displayData);
AssetHelper::getWebAssetManager()->usePreset('joomlab.translation-field')

?>
<div class="jl-scope jl-form__field-translation-container">
    <?php foreach ($fields as $i => $tabField): ?>
        <div data-translation-field-index="<?php echo $i; ?>"<?php echo $i ? ' hidden' : ''; ?>>
            <?php echo $tabField['input']; ?>
        </div>
    <?php endforeach; ?>
    <ul>
        <?php foreach ($fields as $i => $tabField): ?>
            <li>
                <a
                        class="jl-form__field-translation__<?php echo $tabField['lang']; ?>-flag<?php echo $i ? '' : ' active'; ?>"
                        href="#" data-translation-field-index="<?php echo $i; ?>"
                        uk-tooltip title="<?php echo $tabField['lang']; ?>"
                >
                    <?php echo LanguageHelper::langCodeToFlag($tabField['lang']); ?>
                </a>
            </li>
        <?php endforeach; ?>
    </ul>
</div>


