<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLTranslation\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\ListField;
use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;
use Joomla\Plugin\System\JLTranslation\Helper\TranslationHelper;

class TableListField extends ListField
{
    protected $type = 'TableList';

    protected function getOptions()
    {
        $options = parent::getOptions();

        foreach (TranslationHelper::bootExtensions() as $class) {
            /** @var TranslationExtensionAbstract $class */
            $options[] = ['value' => $class->getReferenceTable(), 'text' => $class->getTitle()];
        }

        return $options;
    }
}
