<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLTranslation\Administrator\View\Translations;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\JLTranslation\Helper\TranslationHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;
use Joomla\Plugin\System\Joomlab\MVC\View\ListView;

class HtmlView extends ListView
{
    protected function addToolbar(): void
    {
        $toolbar = BackwardCompatibilityHelper::getToolbar();
        $user    = $this->getCurrentUser();
        $option  = 'com_jltranslation';
        $table   = $this->state->get('filter.table') ?: 'content';
        $class   = TranslationHelper::getClassByTable($table);

        ToolbarHelper::title(Text::sprintf('COM_JLTRANSLATION_TRANSLATION_FOR_EXTENSION', $class->getTitle()));
        $toolbar->link(Text::_('COM_JLTRANSLATION_PAGE_DASHBOARD'), Route::_('index.php?option=com_jltranslation', false));

        if ($user->authorise('core.admin', $option) || $user->authorise('core.options', $option)) {
            $toolbar->preferences($option);
        }
    }
}
