<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;

/**
 * @var Joomla\Component\JLTranslation\Administrator\View\Translation\HtmlView $this
 */

HTMLHelper::_('joomlab.framework');
AssetHelper::getWebAssetManager()
    ->useScript('keepalive')
    ->useScript('form.validate')
    ->useScript('joomlab.tabs-state');
$groups = [];

foreach ($this->originalForm->getFieldsets() as $fieldset) {
    if ($fieldset->name !== 'general') {
        $groups[] = $fieldset;
    }

    foreach ($this->originalForm->getFieldset($fieldset->name) as $field) {
        $group = $field->__get('group');
        $name  = $field->__get('fieldname');
        $this->originalForm->setFieldAttribute($name, 'readonly', 'true', $group);
        $this->originalForm->setFieldAttribute($name, 'required', 'false', $group);
        $this->originalForm->setFieldAttribute($name, 'validate', '', $group);
    }
}

$state    = $this->state->get('translation.enabled');
$table    = $this->state->get('filter.table');
$language = $this->state->get('filter.language');
$tmpl     = Factory::getApplication()->input->get('tmpl', '');
$url      = 'index.php?option=com_jltranslation&view=translation&filter[table]=' . $table . '&filter[language]=' . $language . '&tmpl=' . $tmpl . '&layout=edit&id=' . $this->item->id;
$isModal  = $tmpl === 'component';
?>
<form action="<?php echo Route::_($url, false); ?>"
      method="post" name="adminForm" id="item-form" class="form-validate jl-scope form-vertical">
    <div class="uk-card<?php echo $isModal ? '' : ' uk-card-body uk-card-default'; ?>">
        <?php if ($isModal): ?>
            <div class="uk-grid-small uk-padding-small uk-background-default" uk-grid uk-sticky>
                <div class="uk-flex-1">
                    <h3 class="uk-heading-bullet"><?php echo $this->pageTitle; ?></h3>
                </div>
                <div class="uk-flex-none">
                    <input type="hidden" name="task" value="translation.apply">
                    <button class="uk-button uk-button-default uk-modal-close" type="button">
                        <?php echo Text::_('JTOOLBAR_CANCEL'); ?>
                    </button>
                    <button class="uk-button uk-button-primary" type="submit">
                        <?php echo Text::_('JTOOLBAR_APPLY'); ?>
                    </button>
                </div>
            </div>
        <?php else: ?>
            <input type="hidden" name="task" value="">
        <?php endif; ?>
        <div class="uk-background-muted uk-padding-small">
            <div class="uk-form-horizontal uk-width-large">
                <label class="uk-form-label" for="translation-state">
                    <?php echo Text::_('COM_JLTRANSLATION_ENABLED'); ?>
                </label>
                <div class="uk-form-controls">
                    <select class="uk-select" name="state" id="translation-state">
                        <option value="1"<?php echo $state ? ' selected' : ''; ?>>
                            <?php echo Text::_('JYES'); ?>
                        </option>
                        <option value="0"<?php echo !$state ? ' selected' : ''; ?>>
                            <?php echo Text::_('JNO'); ?>
                        </option>
                    </select>
                </div>
            </div>
        </div>
        <ul uk-tab>
            <li class="uk-active">
                <a href="#"><?php echo Text::_('COM_JLTRANSLATION_TAB_GENERAL'); ?></a>
            </li>
            <?php foreach ($groups as $group): ?>
                <li>
                    <a href="#"><?php echo Text::_($group->label); ?></a>
                </li>
            <?php endforeach; ?>
        </ul>
        <ul class="uk-switcher uk-margin">
            <li>
                <div class="uk-grid-divider uk-child-width-1-2@m" uk-grid>
                    <div><?php echo $this->originalForm->renderFieldset('general'); ?></div>
                    <div><?php echo $this->translatedForm->renderFieldset('general'); ?></div>
                </div>
            </li>
            <?php foreach ($groups as $group): ?>
                <li>
                    <div class="uk-grid-divider uk-child-width-1-2@m" uk-grid>
                        <div><?php echo $this->originalForm->renderFieldset($group->name); ?></div>
                        <div><?php echo $this->translatedForm->renderFieldset($group->name); ?></div>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php echo HTMLHelper::_('form.token'); ?>
</form>
