<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Installer\InstallerScript;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

return new class() implements ServiceProviderInterface {
    public function register(Container $container)
    {
        $container->set(
            InstallerScriptInterface::class,
            new class() extends InstallerScript {
                protected $minimumJoomla = '4.4';

                protected $minimumPhp = '8.1';

                public function postflight(string $route, InstallerAdapter $adapter)
                {
                    if (!in_array($route, ['install', 'uninstall', 'update'])) {
                        return true;
                    }

                    $helperClass = '\\Joomla\\Plugin\\System\\Joomlab\\Helper\\InstallerHelper';
                    $source      = $adapter->getParent()->getPath('source');

                    if (!class_exists($helperClass)) {
                        $path = $source . '/plugins/system/joomlab/src/Helper/InstallerHelper.php';

                        if (is_file($path)) {
                            require_once $path;
                        }

                        if (!class_exists($helperClass)) {
                            return false;
                        }
                    }

                    if ('uninstall' === $route) {
                        $helperClass::uninstallExtensions([
                            'mod_jltranslation_languages',
                            'plg_jltranslation_hikashop',
                            'plg_jltranslation_solidres',
                            'plg_jltranslation_pro',
                            'plg_system_jltranslation',
                        ]);
                    } else {
                        $helperClass::installExtensions($source);
                    }

                    return true;
                }
            }
        );
    }
};