<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */


defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Uri\Uri;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;

/**
 * @var Joomla\Registry\Registry $params
 * @var SiteRouter               $router
 */
$hasTitle = true;
$router   = Factory::getContainer()->get(SiteRouter::class);
$query    = Factory::getApplication()->getInput()->getArray();

if (isset($query['language'])) {
    unset($query['language']);
}

$languages  = array_map(function ($language) use ($router, $params, $query, &$hasTitle) {
    $lang              = new stdClass();
    $lang->id          = $language->id;
    $lang->code        = $language->lang_code;
    $lang->flag        = LanguageHelper::langCodeToFlag($language->lang_code);
    $lang->title       = $language->title;
    $lang->titleNative = $language->title_native;

    switch ($params->get('displayTitle')) {
        case 'titleNative':
            $lang->displayTitle = $lang->flag . ' ' . $language->title_native;
            break;

        case 'flagOnly':
            $lang->displayTitle = $lang->flag;
            $hasTitle           = false;
            break;

        case 'flagAndCode':
            $lang->displayTitle = $lang->flag . ' ' . $language->lang_code;
            break;

        case 'title':
        default:
            $lang->displayTitle = $lang->flag . ' ' . $language->title;
            break;
    }

    try {
        $uri = clone Uri::getInstance();
        $uri->setVar('lang', $language->lang_code);
        $vars      = $router->parse($uri);
        $lang->url = Route::_('index.php?option=com_ajax&module=JLTranslation_languages&format=raw&lang=' . $language->lang_code . '&vars=' . base64_encode(json_encode($vars)), false);
    } catch (Throwable $e) {
        $query['lang'] = $language->lang_code;
        $lang->url     = Route::_('index.php?option=com_ajax&module=JLTranslation_languages&format=raw&lang=' . $language->lang_code . '&vars=' . base64_encode(json_encode($query)), false);
    }

    return $lang;
}, LanguageHelper::getLanguages());
$layout     = $params->get('layout', 'default');
$activeLang = Factory::getApplication()->getLanguage()->getTag();
$wa         = AssetHelper::getWebAssetManager();
$wa->getRegistry()->addRegistryFile('media/com_jltranslation/joomla.asset.json');
$wa->usePreset('com_jltranslation.module-languages');

require ModuleHelper::getLayoutPath('mod_jltranslation_languages', $layout . '_' . $params->get('displayType', 'inline'));