<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * @var array  $languages
 * @var string $activeLang
 * @var bool   $hasTitle
 */
?>

<div class="mod_jltranslation_languages__inline<?php echo $hasTitle ? ' has-title' : ''; ?>">
    <ul>
        <?php foreach ($languages as $language): ?>
            <li>
                <?php if ($language->code === $activeLang): ?>
                    <span><?php echo $language->displayTitle; ?></span>
                <?php else: ?>
                    <a class="mod_jltranslation_languages__url" href="<?php echo $language->url; ?>" data-language="<?php echo $language->code; ?>">
                        <?php echo $language->displayTitle; ?>
                    </a>
                <?php endif; ?>
            </li>
        <?php endforeach; ?>
    </ul>
</div>