<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\Input\Input;
use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;

abstract class TranslationExtensionBase extends TranslationExtensionAbstract
{
    public function prepareTranslationForm(): Form
    {
        Factory::getApplication()
            ->getLanguage()
            ->load('com_hikashop', JPATH_ROOT);
        /** @var Form $form */
        $parts = explode('\\', get_class($this));
        $name  = strtolower($parts[count($parts) - 1]);
        $form  = Factory::getContainer()
            ->get(FormFactoryInterface::class)
            ->createForm('category', ['control' => 'jform']);
        $form->loadFile(JPATH_PLUGINS . '/jltranslation/hikashop/forms/' . $name . '.xml');

        return $form;
    }

    public function getEditViewId(Input $input): array
    {
        $view = $input->getCmd('ctrl');
        $id   = (int)($input->get('cid', [], 'ARRAY')[0] ?? 0);

        return [$view, $id];
    }

}