<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Event;

defined('_JEXEC') or die;

use Joomla\Event\Event;

class RegisterTranslationFieldsEvent extends Event
{
    public function __construct(array $arguments = [])
    {
        parent::__construct('onRegisterTranslationFields', $arguments);
    }

    public function getFields(): array
    {
        return $this->getArgument('fields');
    }

    public function updateFields(array $fields): static
    {
        return $this->setArgument('fields', $fields);
    }

    public function getExtension(): string
    {
        return $this->getArgument('extension');
    }

    public function getModel(): string
    {
        return $this->getArgument('model');
    }
}