<?php
/**
 * @package     JLTranslation.Administrator
 * @subpackage  com_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Event;

defined('_JEXEC') or die;

use Joomla\Event\Event;
use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;

class TranslationToolbarButtonEvent extends Event
{
    public const EVENT_NAME = 'onJLTranslationToolbarButton';

    public function __construct(array $arguments = [])
    {
        parent::__construct(static::EVENT_NAME, $arguments);
    }

    public function getReferenceTable(): string
    {
        return $this->getExtensionClass()->getReferenceTable();
    }

    public function getExtensionClass(): TranslationExtensionAbstract
    {
        return $this->getArgument('subject');
    }

    public function getContext(): string
    {
        return $this->getExtensionClass()->getBaseContext() . '.' . $this->getReferenceId();
    }

    public function getReferenceId(): int
    {
        return $this->getArgument('pk');
    }
}