<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Extension\Banners;

defined('_JEXEC') or die;

use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionAbstract;

class Banner extends TranslationExtensionAbstract
{
    public function registerTranslationFields(): array
    {
        return [
            'name',
            'alias',
            'description',
            'clickurl',
            'metakey',
            'metakey_prefix',
            'custombannercode',
            'params.imageurl',
            'params.alt',
        ];
    }

    public function getTitleField(): ?string
    {
        return 'name';
    }

    public function getReferenceTable(): string
    {
        return 'banners';
    }
}