<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Extension\Menus;

defined('_JEXEC') or die;

use Joomla\Plugin\System\JLTranslation\Extension\TranslationExtensionNested;

class Item extends TranslationExtensionNested
{
    public function registerTranslationFields(): array
    {
        return [
            'title',
            'alias',
            'params.menu-anchor_title',
            'params.menu_image',
            'params.page_title',
            'params.page_heading',
            'params.menu-meta_description',
        ];
    }

    public function getTitleField(): ?string
    {
        return 'title';
    }

    public function getReferenceTable(): string
    {
        return 'menu';
    }
}