<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Extension;

defined('_JEXEC') or die;

use Joomla\Database\ParameterType;
use Joomla\Plugin\System\JLTranslation\Helper\TranslationHelper;

abstract class TranslationExtensionNested extends TranslationExtensionAbstract
{
    public function prepareSaveData(string $context, string $langCode, object $item, array &$translation): void
    {
        $alias       = trim($translation['alias'] ?? '') ?: $item->alias;
        $parentId    = (int)($item->parent_id ?? 0);
        $baseContext = preg_replace('/\.\d+$/', '', $context);
        $parentPaths = [];
        $db          = $this->getDatabase();
        $loadData    = function ($itemId) use ($db) {
            $query = $db->getQuery(true)
                ->select('*')
                ->from($db->quoteName('#__' . $this->getReferenceTable()))
                ->where($db->quoteName($this->getKey()) . ' = :id')
                ->bind(':id', $itemId, ParameterType::INTEGER);

            return $db->setQuery($query)->loadObject();
        };

        while ($parentId > 0 && ($parent = $loadData($parentId))) {
            $data          = TranslationHelper::getTranslationData($baseContext . '.' . $parentId, $langCode);
            $parentPaths[] = ($data['path'] ?? '') ?: $parent->path;
            $parentId      = $parent->parent_id;
        }

        $translation['path'] = ltrim(implode('/', array_reverse($parentPaths)) . '/' . $alias, '/');
        parent::prepareSaveData($context, $langCode, $item, $translation);
    }
}