<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Component\JLTranslation\Administrator\Extension\JLTranslationComponent;
use Joomla\Plugin\System\JLTranslation\Helper\TranslationHelper;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;

HTMLHelper::_('joomlab.framework');

/** @var WebAssetManager $wa */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('table.columns')->useScript('multiselect');

$app             = Factory::getApplication();
$user            = $this->getCurrentUser();
$userId          = $user->get('id');
$listOrder       = $this->escape($this->state->get('list.ordering'));
$listDirn        = $this->escape($this->state->get('list.direction'));
$table           = $this->state->get('filter.table') ?: 'content';
$defaultSiteLang = LanguageHelper::getDefaultLang();
$languages       = array_values(
    array_filter(LanguageHelper::getLanguageCodes(), function ($language) use ($defaultSiteLang) {
        return $defaultSiteLang !== $language;
    })
);

?>

<form action="<?php echo Route::_('index.php?option=com_jltranslation&view=translations', false); ?>" method="post" name="adminForm"
      class="jl-scope" id="adminForm">
    <div id="j-main-container" class="j-main-container uk-card uk-card-small uk-card-body uk-card-default">
        <?php
        // Search tools bar
        echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]);
        ?>
        <?php if (empty($this->items)) : ?>
            <div class="alert alert-info">
                <span class="icon-info-circle" aria-hidden="true"></span><span
                        class="visually-hidden"><?php
                    echo Text::_('INFO'); ?></span>
                <?php
                echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php else : ?>
            <table class="uk-table uk-table-hover uk-table-divider uk-table-small uk-table-responsive" id="translationList">
                <caption class="visually-hidden">
                    <?php echo Text::_('COM_JLTRANSLATION_TRANSLATIONS'); ?>,
                    <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?></span>,
                    <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
                </caption>
                <thead>
                <tr>
                    <th class="uk-table-expand">
                        <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'title', $listDirn, $listOrder); ?>
                    </th>
                    <?php foreach ($languages as $language): ?>
                        <th class="uk-table-shrink uk-text-nowrap">
                            <?php echo LanguageHelper::langCodeToFlag($language) . ' ' . $language; ?>
                        </th>
                    <?php endforeach; ?>

                    <th class="uk-table-shrink uk-text-nowrap uk-visible@s">
                        <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'id', $listDirn, $listOrder); ?>
                    </th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($this->items as $i => $item) :

                    $card = TranslationHelper::getDashboardCardData($table, (int)$item->id);
                    $langCount = count($languages);
                    ?>
                    <tr class="row<?php echo $i % 2; ?>">
                        <td>
                            <div class="uk-text-emphasis">
                                <a href="<?php echo $langCount === 1 ? Route::_('index.php?option=com_jltranslation&view=translation&filter[table]=' . $table . '&filter[language]=' . $languages[0] . '&layout=edit&id=' . $item->id) : '#' ?>"
                                   class="uk-link-reset">
                                    <?php echo $this->escape($item->title); ?>
                                </a>

                                <?php if ($langCount > 1): ?>
                                    <div uk-dropdown="mode: click">
                                        <ul class="uk-nav uk-dropdown-nav">
                                            <?php foreach ($languages as $language): ?>
                                                <li>
                                                    <a href="<?php echo Route::_('index.php?option=com_jltranslation&view=translation&filter[table]=' . $table . '&filter[language]=' . $language . '&layout=edit&id=' . $item->id,
                                                        false); ?>">
                                                        <?php echo LanguageHelper::langCodeToFlag($language) . ' ' . $language; ?>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </td>
                        <?php foreach ($card['count'] as $language => $count): ?>
                            <td class="uk-text-nowrap">
                                <?php echo $count['enabled'] . ' <i class="fa fa-check-circle text-primary"></i>' ?>
                                <?php echo $count['disabled'] . ' <i class="fa fa-times-circle text-danger"></i>'; ?>
                            </td>
                        <?php endforeach; ?>
                        <td class="uk-visible@s">
                            <?php echo $item->id; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <?php echo $this->pagination->getListFooter(); ?>
        <?php endif; ?>
        <input type="hidden" name="task" value="">
        <?php echo HTMLHelper::_('form.token'); ?>
    </div>
    <?php echo JLTranslationComponent::renderBottomLink(); ?>
</form>
