document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('a.mod_jltranslation_languages__url[href]').forEach(a => {
        fetch(a.href,
            {
                method: 'GET',
                credentials: 'omit',
                headers: {
                    'Cache-Control': 'no-cache', // Prevents cached responses
                    'Pragma': 'no-cache', // Additional cache bypass
                    'x-requested-with': 'XMLHttpRequest',
                }
            })
            .then(res => res.text())
            .then(url => a.href = url);
    });

    const drops = document.querySelectorAll('.mod_jltranslation_languages__dropdown');

    drops.forEach(drop => {
        drop.querySelector('.mod_jltranslation_languages__dropdown__title')
            .addEventListener('click', e => {
                e.preventDefault();
                const box = drop.querySelector('.mod_jltranslation_languages__dropdown__box');
                box.hidden = !box.hidden;
            });
    });

    document.addEventListener('click', e => {
        drops.forEach(drop => {
            const title = drop.querySelector('.mod_jltranslation_languages__dropdown__title');
            const box = drop.querySelector('.mod_jltranslation_languages__dropdown__box');
            if (!title.contains(e.target) && !box.contains(e.target)) {
                box.hidden = true;
            }
        });
    });
});