<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * @var array  $languages
 * @var string $activeLang
 * @var bool   $hasTitle
 */

?>

<div class="mod_jltranslation_languages__dropdown<?php echo $hasTitle ? ' has-title' : ''; ?>">
    <div class="mod_jltranslation_languages__dropdown__title">
        <?php
        foreach ($languages as $language) {
            if ($language->code === $activeLang) {
                echo $language->displayTitle;
                break;
            }
        }
        ?>
        <i class="fa fa-caret-down"></i>
    </div>
    <div class="mod_jltranslation_languages__dropdown__box" hidden>
        <ul>
            <?php foreach ($languages as $language): ?>
                <?php if ($language->code !== $activeLang): ?>
                    <li>
                        <a class="mod_jltranslation_languages__url" href="<?php echo $language->url; ?>" data-language="<?php echo $language->code; ?>">
                            <?php echo $language->displayTitle; ?>
                        </a>

                    </li>
                <?php endif; ?>
            <?php endforeach; ?>
        </ul>
    </div>
</div>