<?php
/**
 * @package     JLTranslation.Administrator
 * @subpackage  com_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLTranslation\Administrator\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Component\Router\RouterServiceInterface;
use Joomla\CMS\Component\Router\RouterServiceTrait;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Psr\Container\ContainerInterface;

final class JLTranslationComponent extends MVCComponent implements
    BootableExtensionInterface, RouterServiceInterface
{
    use RouterServiceTrait;
    use HTMLRegistryAwareTrait;

    public const MAJOR_VERSION = 1;

    public const MINOR_VERSION = 0;

    public const PATCH_VERSION = 3;

    public const  FULL_VERSION = '1.0.4';

    public const  HASH_VERSION = '15ca96027c93710f1c31c3be18b218de';

    public static function renderBottomLink(): string
    {
        return ComponentHelper::getParams('com_jltranslation')->get('removeBottomLink')
            ? ''
            : '<p style="text-align: center; font-size: 14px; color: #555">'
            . '   <a href="https://joomlab.net/joomlab-form" target="_blank">Joomlab Translation</a><sup>v' . JLTranslationComponent::FULL_VERSION . '</sup> is Free Software released under the GNU General Public License.<br>'
            . '   If you enjoyed your experience with our product, please take a moment to leave a <a href="https://extensions.joomla.org/extension/languages/multi-lingual-content/jl-translation" target="_blank">review on JED</a>'
            . '</p>';
    }

    public function boot(ContainerInterface $container) {}
}
