(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.fo = {}));
})(this, (function (exports) { 'use strict';

  var fp = typeof window !== "undefined" && window.flatpickr !== undefined
      ? window.flatpickr
      : {
          l10ns: {},
      };
  var Faroese = {
      weekdays: {
          shorthand: ["Sun", "Mán", "Týs", "Mik", "Hós", "Frí", "Ley"],
          longhand: [
              "Sunnudagur",
              "Mánadagur",
              "Týsdagur",
              "Mikudagur",
              "Hósdagur",
              "Fríggjadagur",
              "Leygardagur",
          ],
      },
      months: {
          shorthand: [
              "Jan",
              "Feb",
              "Mar",
              "Apr",
              "Mai",
              "Jun",
              "Jul",
              "Aug",
              "Sep",
              "Okt",
              "Nov",
              "Des",
          ],
          longhand: [
              "Januar",
              "Februar",
              "Mars",
              "Apríl",
              "Mai",
              "Juni",
              "Juli",
              "August",
              "Septembur",
              "Oktobur",
              "Novembur",
              "Desembur",
          ],
      },
      ordinal: function () {
          return ".";
      },
      firstDayOfWeek: 1,
      rangeSeparator: " til ",
      weekAbbreviation: "vika",
      scrollTitle: "Rulla fyri at broyta",
      toggleTitle: "Trýst fyri at skifta",
      yearAriaLabel: "Ár",
      time_24hr: true,
  };
  fp.l10ns.fo = Faroese;
  var fo = fp.l10ns;

  exports.Faroese = Faroese;
  exports["default"] = fo;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
