<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\JLTranslation\Hikashop\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\User\UserFactoryAwareInterface;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;
use Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop\Category;
use Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop\Characteristic;
use Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop\Payment;
use Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop\Product;
use Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop\Shipping;
use Joomla\Plugin\JLTranslation\Hikashop\Extension\Hikashop\Zone;
use Joomla\Plugin\System\JLTranslation\Event\ExtensionEvent;

final class Hikashop extends CMSPlugin implements DatabaseAwareInterface, UserFactoryAwareInterface, SubscriberInterface
{
    use DatabaseAwareTrait;
    use UserFactoryAwareTrait;

    protected $autoloadLanguage = true;


    public static function getSubscribedEvents(): array
    {
        return ComponentHelper::isEnabled('com_hikashop') ? [
            'onJLTranslationBootExtensions' => 'bootExtensions',
        ] : [];
    }

    public function bootExtensions(ExtensionEvent $event): void
    {
        $subject       = $event->getArgument('subject');
        $subject->data = array_merge(
            $subject->data,
            [
                Product::class,
                Category::class,
                Zone::class,
                Payment::class,
                Characteristic::class,
                Shipping::class,
            ]
        );
    }
}