<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_jltranslation
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\JLTranslation\Event;

defined('_JEXEC') or die;

class RegisterEventData
{
    public function __construct(
        public array $prepareForm,
        public array $prepareData,
        public array $prepareField,
        public array $afterSave = []
    ) {}

    public function addItem(string $property, mixed $value): static
    {
        if (property_exists($this, $property) && is_array($this->{$property})) {
            $this->$property[] = $value;
        }

        return $this;
    }
}