<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Helper;

defined('_JEXEC') or die;

use Joomla\Utilities\IpHelper;

class UtilityHelper
{
    public static function parseJson(string $jsonString): null|array
    {
        $jsonStrings = [];
        $jsonString  = preg_replace(
            ['/(\s+;)|(;\s+)|;+/', '/(\s+:)|(:\s+)|:+/'],
            [';', ':'],
            trim(
            // Temp replace some markup strings
                str_replace(
                    ['[;]', '[:]', '["]'],
                    ['#0', '#1', '#2'],
                    $jsonString
                )
            )
        );

        foreach (preg_split('/\s*;\s*/', $jsonString, -1, PREG_SPLIT_NO_EMPTY) as $str) {
            if (!str_contains($str, ':')) {
                return null;
            }

            [$k, $v] = preg_split('/\s*:\s*/', trim($str), 2);
            $k = trim($k, '"');

            // Revert markup strings to real strings
            $jsonStrings[$k] = str_replace(['#0', '#1', '#2'], [';', ':', '&quot;'], trim($v, '"'));

            // Check to convert to boolean (maybe)
            if (in_array($jsonStrings[$k], ['true', 'false'])) {
                $jsonStrings[$k] = $jsonStrings[$k] === 'true';
            }
        }

        $jsonString = json_encode($jsonStrings);

        if (str_starts_with($jsonString, '{') || str_starts_with($jsonString, '[')) {
            $json = json_decode($jsonString, true);

            return json_last_error() === JSON_ERROR_NONE ? $json : [];
        }

        return null;
    }

    public static function getCountriesList(): array
    {
        static $countries = null;

        if (null === $countries) {
            $countries = json_decode(file_get_contents(__DIR__ . '/countries.json'), true);
        }

        return $countries;
    }

    public static function isAjaxRequest(): bool
    {
        $requestedWith = $_SERVER['HTTP_X_REQUESTED_WITH'] ?? '';

        return strcasecmp($requestedWith, 'Fetch') === 0 || strcasecmp($requestedWith, 'XMLHttpRequest') === 0;
    }

    public static function getClientIP(): string
    {
        return $_SERVER['HTTP_CF_CONNECTING_IP'] // Cloudflare
            ?? IpHelper::getIp(); // Fallback
    }
}