<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\Dashboard;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;

class HtmlView extends BaseHtmlView
{
    protected bool $advanced = false;

    public function display($tpl = null)
    {
        $this->advanced = PluginHelper::isEnabled('jladmin', 'pro');
        $this->addToolbar();
        parent::display($tpl);
    }

    protected function addToolbar()
    {
        $toolbar = BackwardCompatibilityHelper::getToolbar();
        $user    = $this->getCurrentUser();
        $option  = 'com_jladmin';
        ToolbarHelper::title(Text::_('COM_JLADMIN_DASHBOARD'));

        if ($user->authorise('core.manage', $option)) {
            $toolbar->link(Text::_('COM_JLADMIN_CLEAR_CACHE'), Route::_('index.php?option=com_jladmin&task=oneClick.clearCache', false))
                ->setOption('icon', 'fa-solid fa-bolt');

            $toolbar->link(Text::_('COM_JLADMIN_CLEAR_TMP'), Route::_('index.php?option=com_jladmin&task=oneClick.clearTmp', false))
                ->setOption('icon', 'fa-solid fa-file-pen');

            $toolbar->link(Text::_('COM_JLADMIN_CLEAR_LOGS'), Route::_('index.php?option=com_jladmin&task=oneClick.clearLogs', false))
                ->setOption('icon', 'fa-solid fa-clock-rotate-left');
        }

        if ($user->authorise('core.admin', $option) || $user->authorise('core.options', $option)) {
            $toolbar->preferences($option);
        }
    }
}
