<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;

/** @var Joomla\Component\JLAdmin\Administrator\View\BackupProfile\HtmlView $this */

AssetHelper::getWebAssetManager()
    ->useScript('keepalive')
    ->useScript('form.validate');
HTMLHelper::_('joomlab.framework');

?>
<form action="<?php echo Route::_('index.php?option=com_jladmin&view=backupProfile&layout=edit&id=' . (int)$this->item->id, false); ?>"
      method="post" name="adminForm" id="item-form" class="form-validate form-vertical jl-scope">

    <div class="uk-card uk-card-default uk-card-body">
        <div class="uk-grid-divider uk-child-width-1-2@m" uk-grid>
            <div>
                <?php echo $this->form->renderFieldset('general'); ?>
            </div>
            <div>
                <?php foreach ($this->form->getGroup('params') as $field): ?>
                    <?php echo $field->renderField(); ?>
                <?php endforeach; ?>
            </div>
        </div>

    </div>


    <input type="hidden" name="task" value="">
    <?php echo HTMLHelper::_('form.token'); ?>
</form>
