<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\MVC\Model;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\AdminModel as BaseAdminModel;
use Joomla\Plugin\System\Joomlab\Table\Table;

class AdminModel extends BaseAdminModel
{
    protected string $context;

    public function __construct($config = [], MVCFactoryInterface $factory = null, FormFactoryInterface $formFactory = null)
    {
        parent::__construct($config, $factory, $formFactory);
        $this->context = strtolower($this->option . '.' . $this->getName());
    }

    public function getTable($name = '', $prefix = 'Administrator', $options = []): Table
    {
        if (empty($name)) {
            $ns   = explode('\\', get_class($this));
            $name = preg_replace('/Model$/', '', array_pop($ns));
        }
        
        if ($table = $this->_createTable($name, $prefix, $options)) {
            /** @var Table */
            return $table;
        }

        throw new Exception(Text::sprintf('JLIB_APPLICATION_ERROR_TABLE_NAME_NOT_SUPPORTED', $name), 0);
    }


    public function getForm($data = [], $loadData = true): false|Form
    {
        // Get the form.
        $form = $this->loadForm($this->context, $this->getName(), ['control' => 'jform', 'load_data' => $loadData]);

        if (empty($form)) {
            return false;
        }

        return $form;
    }

    protected function canDelete($record): bool
    {
        if (!empty($record->id)) {
            return $this->getCurrentUser()->authorise('core.delete', $this->context . '.' . (int)$record->id);
        }

        return false;
    }

    protected function canEditState($record): bool
    {
        // Check for existing article.
        if (!empty($record->id)) {
            return $this->getCurrentUser()->authorise('core.edit.state', $this->context . '.' . (int)$record->id);
        }

        return parent::canEditState($record);
    }

    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState($this->option . '.edit.' . $this->name . '.data', []);

        if (empty($data)) {
            $data = $this->getItem();
        } else {
            // For consistent data as object
            $data = (object)$data;
        }

        $this->preprocessData($this->context, $data);

        return $data;
    }
}
