<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
/** @var array $displayData */
?>
<div class="uk-padding-small uk-background-muted jl-admin__source__tree uk-overflow-auto">
    <ul class="uk-list">
        <?php foreach ($displayData['folders'] as $folder): ?>
            <li>
                <a class="jl-admin__source__folder uk-link-reset uk-text-nowrap" data-path="<?php echo preg_replace('#^' . preg_quote(JPATH_ROOT, '#') . '/#', '', $folder, 1); ?>">
                    <span uk-icon="folder"></span>
                    <span class="jl-admin__source__name">
                        <?php echo basename($folder); ?>
                    </span>
                </a>
            </li>
        <?php endforeach; ?>

        <?php foreach ($displayData['files'] as $file): ?>
            <li>
                <a class="jl-admin__source__file uk-link-reset uk-text-nowrap" data-path="<?php echo preg_replace('#^' . preg_quote(JPATH_ROOT, '#') . '/#', '', $file, 1); ?>">
                    <span uk-icon="file"></span>
                    <span class="jl-admin__source__name">
                        <?php echo basename($file); ?>
                    </span>
                </a>
            </li>
        <?php endforeach; ?>
    </ul>
</div>