<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Response\JsonResponse;
use Joomla\Plugin\System\Joomlab\Helper\FileSystemHelper;
use RuntimeException;
use Throwable;

class OneClickController extends BaseController
{
    public function clearCache()
    {
        try {
            $this->authorise();

            FileSystemHelper::cleanFolder([
                JPATH_CACHE,
                JPATH_ROOT . '/cache',
                JPATH_ADMINISTRATOR . '/cache',
            ]);

            echo new JsonResponse(null, Text::sprintf('COM_JLADMIN_ACTION_SUCCESSFULLY_MSG', Text::_('COM_JLADMIN_CLEAR_CACHE')));
        } catch (Throwable $e) {
            echo new JsonResponse($e);
        }
    }

    private function authorise(): void
    {
        if (!$this->checkToken('request', false)) {
            throw new RuntimeException(Text::_('JINVALID_TOKEN_NOTICE'));
        }

        if (!$this->app->getIdentity()->authorise('core.manage', 'com_jladmin')) {
            throw new NotAllowed(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }
    }

    public function clearLogs()
    {
        try {
            $this->authorise();
            FileSystemHelper::cleanFolder($this->app->get('log_path'));

            echo new JsonResponse(null, Text::sprintf('COM_JLADMIN_ACTION_SUCCESSFULLY_MSG', Text::_('COM_JLADMIN_CLEAR_LOGS')));
        } catch (Throwable $e) {
            echo new JsonResponse($e);
        }
    }

    public function clearTmp()
    {
        try {
            $this->authorise();
            FileSystemHelper::cleanFolder([
                sys_get_temp_dir(),
                JPATH_ROOT . '/tmp',
                JPATH_ADMINISTRATOR . '/tmp',
            ]);

            echo new JsonResponse(null, Text::sprintf('COM_JLADMIN_ACTION_SUCCESSFULLY_MSG', Text::_('COM_JLADMIN_CLEAR_TMP')));
        } catch (Throwable $e) {
            echo new JsonResponse($e);
        }
    }
}
