<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\BackupCloudStorages;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\MVC\View\ListView;

class HtmlView extends ListView
{
    protected $_name = 'backupCloudStorages';

    public function __construct($config = [])
    {
        if (JLADMIN_PRO) {
            $config['template_path'] = JPATH_PLUGINS . '/jladmin/pro/app/tmpl/backupCloudStorages';
        }

        parent::__construct($config);
    }

    public function display($tpl = null): void
    {
        if (JLADMIN_PRO) {
            parent::display($tpl);
        } else {
            echo $this->loadTemplate();
        }
    }

    protected function addToolbar(): void
    {
        $this->option = 'com_jladmin';
        $user         = $this->getCurrentUser();
        $toolbar      = $this->getDocument()
            ->getToolbar();
        ToolbarHelper::title(Text::_('COM_JLADMIN_PAGE_CLOUD_STORAGES'));

        $toolbar->standardButton('downloadBackupCloudStorages', Text::_('COM_JLADMIN_DOWNLOAD'), 'backupCloudStorages.download')
            ->setOption('icon', 'fa-solid fa-cloud-arrow-down')
            ->listCheck(true);

        if ($user->authorise('core.delete', $this->option)) {
            $toolbar->delete('backupCloudStorages.delete')
                ->text('JTOOLBAR_DELETE')
                ->message('PLG_JLADMIN_PRO_CLOUD_STORAGE_CONFIRM_DELETE')
                ->listCheck(true);
        }

        if ($user->authorise('core.admin', $this->option) || $user->authorise('core.options', $this->option)) {
            $toolbar->preferences($this->option);
        }
    }
}