<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\MailTracker;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\MVC\View\ListView;

class HtmlView extends ListView
{
    protected $_name = 'mailTracker';

    public function __construct($config = [])
    {
        if (JLADMIN_PRO) {
            $config['template_path'] = JPATH_PLUGINS . '/jladmin/pro/app/tmpl/mailTracker';
        }

        parent::__construct($config);
    }

    public function display($tpl = null): void
    {
        if (JLADMIN_PRO) {
            parent::display($tpl);
        } else {
            echo $this->loadTemplate();
        }
    }

    protected function addToolbar(): void
    {
        $this->option = 'com_jladmin';
        $user         = $this->getCurrentUser();
        $toolbar      = $this->getDocument()->getToolbar();
        ToolbarHelper::title(Text::_('COM_JLADMIN_PAGE_MAIL_TRACKER'));

        if ($user->authorise('core.delete', $this->option)) {
            $toolbar->delete('mailTracker.delete')
                ->text('JTOOLBAR_DELETE')
                ->message('JGLOBAL_CONFIRM_DELETE')
                ->listCheck(true);
        }

        if ($user->authorise('core.admin', $this->option) || $user->authorise('core.options', $this->option)) {
            $toolbar->preferences($this->option);
        }
    }
}