window.Joomlab = window.Joomlab || {};
Joomlab.admin = Joomlab.admin || {};
Joomlab.admin.backup = (profileId) => {
    const {backupUrl, defaultProfileId} = Joomla.getOptions('com_jladmin');
    const container = document.createElement('div');
    container.className = 'jl-admin__backup-container jl-scope';
    Joomlab.progress.create(
        backupUrl + (profileId ? `${backupUrl.includes('?') ? '&' : '?'}profileId=${profileId}` : ''),
        {
            container,
            label: Joomla.Text._('COM_JLADMIN_STARTING_BACKUP_MSG'),
            onDone: (modalContent) => {
                const div = document.createElement('div');
                div.className = 'uk-text-center';

                const btn = document.createElement('button');
                btn.type = 'button';
                btn.className = 'uk-button uk-button-default';
                btn.innerHTML = '<span uk-icon="reply"></span> ' + Joomla.Text._('COM_JLADMIN_RETURN_TO_BACKUP_LIST');
                btn.addEventListener('click', e => {
                    e.preventDefault();
                    window.location.reload();
                });

                div.appendChild(btn);
                modalContent.appendChild(div);
            },
        }
    );

    const date = new Date();
    const header = Joomla.Text._('COM_JLADMIN_BACKUP_FOR_PROFILE_ID_MSG')
        .replace('%s', profileId || defaultProfileId || 'DEFAULT')
        .replace('%s', date.toString());
    Joomlab.modal.create(container, {
        cls: 'large',
        backdropClick: false,
        closeButton: false,
        header: header,
        body: container,
    });
};