<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Filesystem\Path;

/** @var array $displayData */

$source = $displayData['source'];
$name   = basename($source);

if (false !== ($ownerId = fileowner($source)) && false !== ($ownerInfo = posix_getpwuid($ownerId))) {
    $owner = $ownerId . ':' . $ownerInfo['name'];
} else {
    $owner = 'Unknown';
}

if (false !== ($filePerms = fileperms($source))) {
    $permission = substr(sprintf('%o', $filePerms), -4) . ':' . Path::getPermissions($source);
} else {
    $permission = 'Unknown';
}

if (false !== ($time = filemtime($source))) {
    try {
        $tz   = Factory::getApplication()->getIdentity()->getTimezone();
        $time = Factory::getDate($time, 'UTC');
        $time->setTimezone($tz);
        $time = $time->format('Y-m-d H:i:s e P', true);
    } catch (Throwable $e) {
    }
}

$time = $time ?: 'Unknown';

if ('file' === $displayData['type']):
    if (false !== ($size = filesize($source))) {
        if ($size < 1024) {
            $size = $size . 'B';
        } elseif ($size < 1048576) {
            $size = round($size / 1024, 2) . ' KB';
        } else {
            $size = round($size / 1048576, 2) . 'MB';
        }
    } else {
        $size = 'Unknown';
    }

    $mime = mime_content_type($source) ?: 'Unknown';

    ?>
    <dl class="uk-description-list">
        <dt><?php echo Text::_('COM_JLADMIN_FILE_INFO_NAME'); ?></dt>
        <dd><?php echo $name; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_INFO_SIZE'); ?></dt>
        <dd><?php echo $size; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_INFO_MIME'); ?></dt>
        <dd><?php echo $mime; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_PERMISSION'); ?></dt>
        <dd><?php echo $permission; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_OWNER'); ?></dt>
        <dd><?php echo $owner; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_MODIFIED_TIME'); ?></dt>
        <dd><?php echo $time; ?></dd>
    </dl>

<?php else : ?>
    <dl class="uk-description-list">
        <dt><?php echo Text::_('COM_JLADMIN_FILE_INFO_NAME'); ?></dt>
        <dd><?php echo $name; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_PERMISSION'); ?></dt>
        <dd><?php echo $permission; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_OWNER'); ?></dt>
        <dd><?php echo $owner; ?></dd>

        <dt><?php echo Text::_('COM_JLADMIN_FILE_MODIFIED_TIME'); ?></dt>
        <dd><?php echo $time; ?></dd>
    </dl>
<?php
endif;
