<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Component\JLForm\Administrator\Model\FormsModel;

class BackupProfileField extends ListField
{
    protected $type = 'BackupProfile';

    protected function getOptions()
    {
        /** @var FormsModel $formsModel */
        $app        = Factory::getApplication();
        $formsModel = $app->bootComponent('com_jladmin')
            ->getMVCFactory()->createModel('BackupProfiles', 'Administrator', ['ignore_request' => true]);
        $formsModel->setState('list.select', 'a.id AS value, a.title AS text');
        $formsModel->setState('list.ordering', 'a.title');
        $formsModel->setState('list.direction', 'desc');


        return array_merge(parent::getOptions(), $formsModel->getItems());
    }
}
