<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\Source;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;

class HtmlView extends BaseHtmlView
{
    protected array $data;

    public function display($tpl = null)
    {
        $this->data = $this->getModel()->getData();
        $this->addToolbar();
        parent::display($tpl);
    }

    protected function addToolbar()
    {
        $toolbar = BackwardCompatibilityHelper::getToolbar();
        $user    = $this->getCurrentUser();
        $option  = 'com_jladmin';
        ToolbarHelper::title(Text::_('COM_JLADMIN_PAGE_SOURCES'));

        $toolbar->link(Text::_('COM_JLADMIN_DASHBOARD'), Route::_('index.php?option=com_jladmin', false))
            ->setOption('icon', 'fa-solid fa-gauge');

        if ($user->authorise('core.admin', $option) || $user->authorise('core.options', $option)) {
            $toolbar->preferences($option);
        }
    }
}