<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\JLAdmin\Administrator\Extension\JLAdminComponent;
use Joomla\Component\JLAdmin\Administrator\View\Source\HtmlView;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\LayoutHelper;

/** @var HtmlView $this */

HTMLHelper::_('joomlab.framework', ['coreScripts' => true]);
$wa = AssetHelper::getWebAssetManager();
$wa->getRegistry()
    ->addExtensionRegistryFile('plg_editors_codemirror');
$wa->useStyle('plg_editors_codemirror')
    ->useScript('webcomponent.editor-codemirror');
$wa
    ->usePreset('com_jladmin.source')
    ->addInlineStyle('.CodeMirror {height: 98%!important}');

$this->getDocument()
    ->addScriptOptions('com_jladmin', [
        'advance' => JLADMIN_PRO,
        'source'  => [
            'ajaxBaseUrl' => Uri::base(true) . '/index.php?option=com_jladmin&format=json&' . Session::getFormToken() . '=1',
        ],
    ]);
$options = [
    'autofocus'                 => false,
    'autoRefresh'               => true,
    'lineWrapping'              => true,
    'styleActiveLine'           => true,
    'highlightSelectionMatches' =>
        [
            'showToken'         => true,
            'annotateScrollbar' => true,
        ],
    'lineNumbers'               => true,
    'gutters'                   =>
        [
            0 => 'CodeMirror-linenumbers',
            1 => 'CodeMirror-foldgutter',
            2 => 'CodeMirror-markergutter',
        ],
    'foldGutter'                => true,
    'markerGutter'              => true,
    'mode'                      => 'html',
    'theme'                     => 'default',
    'autoCloseTags'             => true,
    'matchTags'                 => true,
    'scrollbarStyle'            => 'native',
    'keyMap'                    => 'default',
    'keyMapUrl'                 => '',
];

Text::script('COM_JLADMIN_EXTRACT_TO_DIR');
Text::script('COM_JLADMIN_ENTER_NEW_NAME');
Text::script('COM_JLADMIN_ENTER_CONFIRM_DELETE');
Text::script('COM_JLADMIN_COPIED_TO_CLIPBOARD');
Text::script('COM_JLADMIN_CONTEXT_MENU_COPY');
Text::script('COM_JLADMIN_CONTEXT_MENU_CUT');
Text::script('COM_JLADMIN_CONTEXT_MENU_PASTE');
Text::script('COM_JLADMIN_CONTEXT_MENU_NEW_FILE');
Text::script('COM_JLADMIN_CONTEXT_MENU_NEW_FOLDER');
Text::script('COM_JLADMIN_CONTEXT_MENU_COMPRESS');
Text::script('COM_JLADMIN_CONTEXT_MENU_EXTRACT');
Text::script('COM_JLADMIN_CONTEXT_MENU_UPLOAD');
Text::script('COM_JLADMIN_CONTEXT_MENU_DOWNLOAD');
Text::script('COM_JLADMIN_CONTEXT_MENU_RENAME');
Text::script('COM_JLADMIN_CONTEXT_MENU_DELETE');
Text::script('COM_JLADMIN_SOURCE_TREE_WARNING_MSG');
Text::script('COM_JLADMIN_SOURCE_TREE_DONT_SHOW_WARNING_AGAIN');
Text::script('COM_JLADMIN_SOURCE_SAVE_CONFIRM_MSG');
Text::script('COM_JLADMIN_CONTEXT_MENU_FIND_IN_FOLDER');
Text::script('COM_JLADMIN_PERMISSION');
Text::script('COM_JLADMIN_SET_PERMISSION');
Text::script('COM_JLADMIN_SET_PERMISSION_WARN');
Text::script('COM_JLADMIN_CONTEXT_MENU_DUPLICATE');

?>

<div class="jl-scope">
    <div class="jl-admin__source__container uk-card uk-card-default uk-card-small uk-card-body">
        <div class="uk-flex uk-flex-wrap">
            <div class="uk-flex-1">
                <nav class="jl-admin__source__breadcrumb" aria-label="Breadcrumb">
                    <ul class="uk-breadcrumb">
                        <li class="jl-admin__source__root">
                            <a class="jl-admin__source__folder uk-link-reset" data-path="">
                                <span uk-icon="home"></span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            <div class="uk-flex-none">
                <div class="uk-inline jl-admin__source__file__icon-info" hidden>
                    <a class="uk-icon-button" uk-icon="info"></a>
                    <div class="uk-card uk-card-body uk-card-small uk-card-default" uk-drop="mode: hover"></div>
                </div>

                <a class="jl-admin__source__file-save uk-button uk-button-primary uk-button-small" hidden>
                    <span uk-icon="check"></span>
                    <?php echo Text::_('COM_JLADMIN_SOURCE_SAVE'); ?>
                </a>
            </div>
        </div>
        <div class="uk-grid-small" uk-grid uk-height-match>
            <div class="uk-width-auto@m">
                <div class="jl-admin__source__aside-a">
                    <?php echo LayoutHelper::render('source.tree', $this->data); ?>
                </div>
            </div>
            <div class="uk-width-expand@m jl-admin__source__aside-b">
                <div class="uk-height-1-1">
                    <div class="jl-admin__source__main__file-info" hidden></div>
                    <joomla-editor-codemirror options="<?php echo htmlspecialchars(json_encode($options)) ?>" hidden>
                        <textarea id="jl-admin__source__editor" cols="50" rows="25" style="width: 100%; height: 100%"></textarea>
                    </joomla-editor-codemirror>
                </div>
            </div>
        </div>
    </div>
    <?php echo JLAdminComponent::renderBottomLink(); ?>
</div>
