// Init i10n
for (const k in flatpickr.l10ns) {
    if (k !== 'default' && k !== 'en') {
        flatpickr.localize(flatpickr.l10ns[k]);
        break;
    }
}

window.Joomlab = window.Joomlab || {};

Joomlab.calendar = (element) => {
    if (typeof element === 'string') {
        element = document.querySelector(element);
    }

    if (!(element instanceof HTMLElement)) {
        return;
    }

    const calendarOptions = {};

    try {
        const dataOptions = JSON.parse(element.dataset.jlCalendar);
        Object.assign(calendarOptions, dataOptions)
    } catch {
    }


    if (!['single', 'multiple', 'range'].includes(calendarOptions.mode)) {
        calendarOptions.mode = 'single';
    }

    if (!calendarOptions.dateFormat) {
        calendarOptions.dateFormat = 'Y-m-d H:i';
    }

    calendarOptions.showMonths = parseInt(calendarOptions.showMonths);

    if (isNaN(calendarOptions.showMonths) || ![1, 2, 3, 4].includes(calendarOptions.showMonths)) {
        calendarOptions.showMonths = 1;
    }

    calendarOptions.time24 = !['0', 'false', 0, false, undefined].includes(calendarOptions.time24);
    calendarOptions.inline = !['0', 'false', 0, false, undefined].includes(calendarOptions.inline);
    calendarOptions.timeOnly = !['0', 'false', 0, false, undefined].includes(calendarOptions.timeOnly);
    calendarOptions.enableTime = calendarOptions.dateFormat.includes('H:i');
    const parseMinMaxDate = (type) => {
        let dateToCheck = type === 'min' ? calendarOptions.minDate : calendarOptions.maxDate;

        if (!isNaN(parseInt(dateToCheck))) {
            dateToCheck = parseInt(dateToCheck);

            return dateToCheck === 0 ? 'today' : new Date().fp_incr(dateToCheck);
        }

        if (dateToCheck?.length) {
            const [y, m, d] = dateToCheck.split('-');

            if (y) {
                const parts = [y];

                if (m?.length) {
                    parts.push(m.padStart(2, '0'));

                    if (d?.length) {
                        parts.push(d.padStart(2, '0'));
                    }
                }

                if (parts[1] === undefined) {
                    parts[1] = '01';
                }

                if (parts[2] === undefined) {
                    parts[2] = '01';
                }

                dateToCheck = new Date(dateToCheck.join('-'));

                if (!isNaN(dateToCheck.getTime())) {
                    return dateToCheck;
                }
            }
        }
    };

    calendarOptions.minDate = parseMinMaxDate('min') ?? null;
    calendarOptions.maxDate = parseMinMaxDate('max') ?? null;
    calendarOptions.altInput = true;
    calendarOptions.altFormat = calendarOptions.dateFormat;
    calendarOptions.dateFormat = calendarOptions.timeOnly ? 'H:i' : calendarOptions.enableTime ? 'Y-m-d H:i' : 'Y-m-d';
    element.JLCalendar = flatpickr(element, calendarOptions);
};

window.initJLCalendar = Joomlab.calendar;
document.addEventListener('DOMContentLoaded', () => document.querySelectorAll('[data-jl-calendar]').forEach(initJLCalendar));
