<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Event\Plugin\AjaxEvent;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use JVersion;
use RuntimeException;

final class Joomlab extends CMSPlugin implements SubscriberInterface
{
    protected $autoloadLanguage = true;

    use DatabaseAwareTrait;
    use UserFactoryAwareTrait;

    public static function getSubscribedEvents(): array
    {
        return [
            'onAfterInitialiseDocument' => 'onAfterInitialiseDocument',
            'onAfterRoute'              => 'onAfterRoute',
            'onAjaxJoomlab'             => 'onAjaxJoomlab',
        ];
    }

    public function onAfterRoute()
    {
        if (JVersion::MAJOR_VERSION === 4) {
            $this->onAfterInitialiseDocument();
        }
    }

    public function onAfterInitialiseDocument()
    {
        $this->loadLanguage('plg_system_joomlab.sys');
        AssetHelper::getWebAssetManager()
            ->getRegistry()
            ->addExtensionRegistryFile('plg_system_joomlab');
    }

    public function onAjaxJoomlab(AjaxEvent $event)
    {
        $app   = $this->getApplication();
        $input = $app->getInput();

        if (!$app->isClient('administrator') || !$app->getIdentity()->authorise('core.manage', $input->get('option'))) {
            throw new RuntimeException('Access denied');
        }

        $uKey      = $input->get('uKey');
        $extension = trim($input->getString('ext', ''));

        if (empty($uKey)) {
            throw new RuntimeException('The download key must not be empty.');
        }

        if (40 !== strlen($uKey)) {
            throw new RuntimeException('Invalid download key.');
        }

        if (empty($extension)) {
            throw new RuntimeException('The extension must not be empty.');
        }

        $db         = $this->getDatabase();
        $extraQuery = 'uKey=' . $uKey;
        $query      = $db->getQuery(true)
            ->update($db->quoteName('#__update_sites'))
            ->set($db->quoteName('extra_query') . ' = :extraQuery')
            ->where($db->quoteName('name') . ' = :extension')
            ->bind(':extraQuery', $extraQuery)
            ->bind(':extension', $extension);
        $db->setQuery($query)
            ->execute();
        echo new JsonResponse(null, Text::_('PLG_SYSTEM_JOOMLAB_DOWNLOAD_KEY_SAVED_MSG'));
        $app->close();
    }
}
